local ALName, ALPrivate = ...

local AtlasLoot = _G.AtlasLoot
local ItemSet = {}
AtlasLoot.Data.ItemSet = ItemSet
local Requirements = AtlasLoot.Data.Requirements
local AL = AtlasLoot.Locales
local ALIL = AtlasLoot.IngameLocales
local IMAGE_PATH = ALPrivate.ICONS_PATH

local GetItemSetInfo = GetItemSetInfo

-- lua
local assert, type = _G.assert, _G.type
local format = _G.string.format

-- WoW
local GetItemQualityColor, GetItemIcon, GetSpellDescription = _G.GetItemQualityColor, _G.GetItemIcon, _G.GetSpellDescription

local NO_ICON = "Interface\\Icons\\inv_helmet_08"
local ICON_PATH_CLASS = ALPrivate.CLASS_ICON_PATH
local CLASS_BIT_TO_CLASS = ALPrivate.CLASS_BIT_TO_CLASS

local SPECIAL_ICONS = {
	[466] = GetItemIcon(19898), -- Major Mojo Infusion
	[462] = GetItemIcon(19905), -- Zanzil's Concentration
	[465] = GetItemIcon(19863), -- Prayer of the Primal
	[464] = GetItemIcon(19873), -- Overlord's Resolution
	[461] = GetItemIcon(19865), -- The Twin Blades of Hakkari
	[41]  = GetItemIcon(12940), -- Dal'Rend's Arms
	[463] = GetItemIcon(19896), -- Primal Blessing
	[261] = GetItemIcon(18203), -- Spirit of Eskhandar
	[65]  = GetItemIcon(13183), -- Spider's Kiss
}
local COLOR_STRINGS = {}
local ContentPhaseCache = {}
local CLASS_NAMES_WITH_COLORS = {}
local ContentPhase

local function OnInit()
    for i=0,7 do
		local _, _, _, itemQuality = GetItemQualityColor(i)
		COLOR_STRINGS[i] = "|c"..itemQuality
	end

    CLASS_NAMES_WITH_COLORS = AtlasLoot:GetColoredClassNames()
    ContentPhase = AtlasLoot.Data.ContentPhase
end
AtlasLoot:AddInitFunc(OnInit)

local ITEM_SET_DATA = {
	-- [setID] { {itemID's}, armorTypeID, qualityID, itemLevelAvg, allowableClasses, {{setNum, setSpellID}}, replacedSetName }
	[1] = {{11729,11726,11730,11728,11731},3,3,57,0,{{2,9761},{3,7514},{4,9140},{5,7597}}}, -- The Gladiator
	[41] = {{12940,12939},0,3,63,0,{{2,14056}}}, -- Dal'Rend's Arms
	[65] = {{13183,13218},0,3,61,0,{{2,17332}}}, -- Spider's Kiss
	[81] = {{13390,13388,13389,13391,13392},1,3,61,0,{{2,9764},{3,14590},{3,14712},{4,9417},{5,9106},{5,17498}}}, -- The Postmaster
	[121] = {{14637,14640,14636,14638,14641},2,3,61,0,{{2,7516},{3,9140},{4,18686},{5,15465}}}, -- Cadaverous Garb
	[122] = {{14633,14626,14629,14632,14631},1,3,61,0,{{2,7516},{3,7495},{4,18686},{5,14047}}}, -- Necropile Raiment
	[123] = {{14611,14615,14614,14612,14616},3,3,61,0,{{2,7516},{3,9140},{4,18686},{5,13665}}}, -- Bloodmail Regalia
	[124] = {{14624,14622,14620,14623,14621},4,3,61,0,{{2,7516},{3,9764},{4,18686},{5,13665}}}, -- Deathbone Guardian
	[141] = {{15055,15053,15054},2,2,57,0,{{3,9233}}}, -- Volcanic Armor
	[142] = {{15058,15056,21278,15057},2,3,58,32767,{{2,18979},{3,23863},{4,9142}}}, -- Stormshroud Armor
	[143] = {{15063,15062},2,3,59,0,{{2,15465}}}, -- Devilsaur Armor
	[144] = {{15067,15066},2,3,56,0,{{2,14799}}}, -- Ironfeather Armor
	[161] = {{10399,10401,10403,10400,10402},2,2,20,0,{{2,9760},{3,14707},{4,7534},{5,9140}}}, -- Defias Leather
	[162] = {{6473,10413,10412,10410,10411},2,2,22,0,{{2,7694},{3,20607},{4,7679},{5,9106}}}, -- Embrace of the Viper
	[163] = {{10328,10333,10331,10329,10330,10332},3,2,38,0,{{2,9760},{3,7513},{4,14668},{5,20606},{6,15464}}}, -- Chain of the Scarlet Crusade
	[181] = {{16686,16689,16688,16683,16684,16685,16687,16682},1,3,60,0,{{2,29091},{4,30777},{6,27867},{8,18679}}}, -- Magister's Regalia
	[182] = {{16693,16695,16690,16697,16692,16696,16694,16691},1,3,60,0,{{2,14803},{4,30779},{6,27778},{8,18679}}}, -- Vestments of the Devout
	[183] = {{16698,16701,16700,16703,16705,16702,16699,16704},1,3,60,0,{{2,29090},{4,30778},{6,27780},{8,18679}}}, -- Dreadmist Raiment
	[184] = {{16707,16708,16721,16710,16712,16713,16709,16711},2,3,60,0,{{2,29096},{4,30771},{6,27787},{8,18679}}}, -- Shadowcraft Armor
	[185] = {{16720,16718,16706,16714,16717,16716,16719,16715},2,3,60,0,{{2,29097},{4,9344},{4,9334},{6,27781},{8,18679}}}, -- Wildheart Raiment
	[186] = {{16677,16679,16674,16681,16676,16680,16678,16675},3,3,60,0,{{2,29094},{4,30772},{6,27785},{8,18679}}}, -- Beaststalker Armor
	[187] = {{16667,16669,16666,16671,16672,16673,16668,16670},3,3,60,0,{{2,29095},{4,30780},{6,27774},{8,18679}}}, -- The Elements
	[188] = {{16727,16729,16726,16722,16724,16723,16728,16725},4,3,60,0,{{2,29093},{4,30775},{6,27498},{8,18679}}}, -- Lightforge Armor
	[189] = {{16731,16733,16730,16735,16737,16736,16732,16734},4,3,60,0,{{2,29092},{4,30770},{6,27419},{8,18679}}}, -- Battlegear of Valor
	[201] = {{16795,16797,16798,16799,16801,16802,16796,16800},1,4,66,128,{{3,9346},{5,26175},{8,23545}}}, -- Arcanist Regalia
	[202] = {{16813,16816,16815,16819,16812,16817,16814,16811},1,4,66,16,{{3,21973},{5,21092},{8,23550}}}, -- Vestments of Prophecy
	[203] = {{16808,16807,16809,16804,16805,16806,16810,16803},1,4,66,256,{{3,23554},{5,21741},{8,23553}}}, -- Felheart Raiment
	[204] = {{16821,16823,16820,16825,16826,16827,16822,16824},2,4,66,8,{{3,21874},{5,21975},{8,23582}}}, -- Nightslayer Armor
	[205] = {{16834,16836,16833,16830,16831,16828,16835,16829},2,4,66,1024,{{3,23557},{5,18382},{8,23556}}}, -- Cenarion Raiment
	[206] = {{16846,16848,16845,16850,16852,16851,16847,16849},3,4,66,4,{{3,23560},{5,21926},{8,23566}}}, -- Giantstalker Armor
	[207] = {{16842,16844,16841,16840,16839,16838,16843,16837},3,4,66,64,{{3,21895},{5,23572},{8,23573}}}, -- The Earthfury
	[208] = {{16854,16856,16853,16857,16860,16858,16855,16859},4,4,66,2,{{3,23564},{5,7597},{5,18384},{8,21747}}}, -- Lawbringer Armor
	[209] = {{16866,16868,16865,16861,16863,16864,16867,16862},4,4,66,1,{{3,23562},{5,21838},{8,23561}}}, -- Battlegear of Might
	[210] = {{16914,16917,16916,16918,16913,16818,16915,16912},1,4,76,128,{{3,21879},{5,23549},{8,22007}}}, -- Netherwind Regalia
	[211] = {{16921,16924,16923,16926,16920,16925,16922,16919},1,4,76,16,{{3,21894},{5,21853},{8,22010}}}, -- Vestments of Transcendence
	[212] = {{16929,16932,16931,16934,16928,16933,16930,16927},1,4,76,256,{{3,14047},{5,21922},{8,23555}}}, -- Nemesis Raiment
	[213] = {{16908,16832,16905,16911,16907,16910,16909,16906},2,4,76,8,{{3,21881},{5,23558},{8,23581}}}, -- Bloodfang Armor
	[214] = {{16900,16902,16897,16904,16899,16903,16901,16898},2,4,76,1024,{{3,21894},{5,21872},{8,21871}}}, -- Stormrage Raiment
	[215] = {{16939,16937,16942,16935,16940,16936,16938,16941},3,4,76,4,{{3,23559},{5,21928},{8,23578}}}, -- Dragonstalker Armor
	[216] = {{16947,16945,16950,16943,16948,16944,16946,16949},3,4,76,64,{{3,21899},{5,23570},{8,23551}}}, -- The Ten Storms
	[217] = {{16955,16953,16958,16951,16956,16952,16954,16957},4,4,76,2,{{3,23565},{5,24196},{8,23591}}}, -- Judgement Armor
	[218] = {{16963,16961,16966,16959,16964,16960,16962,16965},4,4,76,1,{{3,23563},{5,21890},{8,23548}}}, -- Battlegear of Wrath
	[221] = {{7953,7950,7951,7948,7949,7952},2,2,37,8,{{6,7597}}}, -- Garb of Thero-shan
	[241] = {{17064,17082},0,4,73,0,{{2,18681}}}, -- Shard of the Gods
	[261] = {{18205,18204,18203,18202},0,4,67,0,{{4,22648}}}, -- Spirit of Eskhandar
	[281] = {{16514,16516,16513,16510,16515,16509},4,3,63,1,{{2,13665},{4,22738},{6,14462}}}, -- Champion's Battlegear
	[282] = {{16429,16432,16430,16406,16431,16405},4,3,63,1,{{2,13665},{4,22738},{6,14462}}}, -- Lieutenant Commander's Battlegear
	[301] = {{16521,16524,16522,16519,16523,16518},3,3,63,64,{{2,14049},{4,22804},{6,14462}}}, -- Champion's Earthshaker
	[321] = {{12427,12428,12422,12425,12424,12429,12426},4,2,57,0,{{2,15666},{4,9335},{6,14465}}}, -- Imperial Plate
	[341] = {{16489,16492,16491,16487,16490,16485},1,3,63,128,{{2,14047},{4,23025},{6,14462}}}, -- Champion's Regalia
	[342] = {{17610,17613,17612,17617,17611,17616},1,3,63,16,{{2,14047},{4,23044},{6,14462}}}, -- Champion's Raiment
	[343] = {{16416,16415,16413,16391,16414,16369},1,3,63,128,{{2,14047},{4,23025},{6,14462}}}, -- Lieutenant Commander's Regalia
	[344] = {{17598,17601,17600,17596,17599,17594},1,3,63,16,{{2,14047},{4,23044},{6,14462}}}, -- Lieutenant Commander's Raiment
	[345] = {{17570,17573,17572,17577,17571,17576},1,3,63,256,{{2,14047},{4,23047},{6,14462}}}, -- Champion's Threads
	[346] = {{17566,17569,17568,17564,17567,17562},1,3,63,256,{{2,14047},{4,23047},{6,14462}}}, -- Lieutenant Commander's Threads
	[347] = {{16506,16507,16505,16499,16508,16498},2,3,63,8,{{2,13665},{4,23048},{6,14462}}}, -- Champion's Vestments
	[348] = {{16418,16420,16417,16396,16419,16392},2,3,63,8,{{2,13665},{4,23048},{6,14462}}}, -- Lieutenant Commander's Vestments
	[361] = {{16526,16528,16525,16530,16527,16531},3,3,63,4,{{2,13665},{4,23158},{6,14462}}}, -- Champion's Pursuit
	[362] = {{16428,16427,16425,16403,16426,16401},3,3,63,4,{{2,13665},{4,23158},{6,14462}}}, -- Lieutenant Commander's Pursuit
	[381] = {{16424,16423,16421,16397,16422,16393},2,3,63,1024,{{2,14049},{4,23218},{6,14462}}}, -- Lieutenant Commander's Sanctuary
	[382] = {{16503,16501,16504,16496,16502,16494},2,3,63,1024,{{2,14049},{4,23218},{6,14462}}}, -- Champion's Sanctuary
	[383] = {{16542,16544,16541,16548,16543,16545},4,4,73,1,{{2,14467},{3,22738},{6,14049}}}, -- Warlord's Battlegear
	[384] = {{16478,16480,16477,16484,16479,16483},4,4,73,1,{{2,14467},{3,22738},{6,14049}}}, -- Field Marshal's Battlegear
	[386] = {{16578,16580,16577,16574,16579,16573},3,4,73,64,{{2,14467},{3,22804},{6,14049}}}, -- Warlord's Earthshaker
	[387] = {{16533,16536,16535,16540,16534,16539},1,4,73,128,{{2,14467},{3,23025},{6,14047}}}, -- Warlord's Regalia
	[388] = {{16441,16444,16443,16440,16442,16437},1,4,73,128,{{2,14467},{3,23025},{6,14047}}}, -- Field Marshal's Regalia
	[389] = {{17602,17604,17605,17608,17603,17607},1,4,73,16,{{2,14467},{3,23044},{6,14047}}}, -- Field Marshal's Raiment
	[390] = {{17623,17622,17624,17620,17625,17618},1,4,73,16,{{2,14467},{3,23044},{6,14047}}}, -- Warlord's Raiment
	[391] = {{17591,17590,17592,17588,17593,17586},1,4,73,256,{{2,14467},{3,23047},{6,14047}}}, -- Warlord's Threads
	[392] = {{17578,17580,17581,17584,17579,17583},1,4,73,256,{{2,14467},{3,23047},{6,14047}}}, -- Field Marshal's Threads
	[393] = {{16561,16562,16563,16560,16564,16558},2,4,73,8,{{2,14467},{3,23048},{6,14049}}}, -- Warlord's Vestments
	[394] = {{16455,16457,16453,16454,16456,16446},2,4,73,8,{{2,14467},{3,23048},{6,14049}}}, -- Field Marshal's Vestments
	[395] = {{16465,16468,16466,16463,16467,16462},3,4,73,4,{{2,14467},{3,23158},{6,14384}}}, -- Field Marshal's Pursuit
	[396] = {{16566,16568,16565,16571,16567,16569},3,4,73,4,{{2,14467},{3,23158},{6,14384}}}, -- Warlord's Pursuit
	[397] = {{16451,16449,16452,16448,16450,16459},2,4,73,1024,{{2,14467},{3,23218},{6,14049}}}, -- Field Marshal's Sanctuary
	[398] = {{16550,16551,16549,16555,16552,16554},2,4,73,1024,{{2,14467},{3,23218},{6,14049}}}, -- Warlord's Sanctuary
	[401] = {{16434,16436,16433,16410,16435,16409},4,3,63,2,{{2,7496},{2,28118},{4,23302},{6,14462}}}, -- Lieutenant Commander's Aegis
	[402] = {{16474,16476,16473,16471,16475,16472},4,4,73,2,{{2,14467},{3,23302},{6,14047}}}, -- Field Marshal's Aegis
	[421] = {{19682,19683,19684},1,3,65,0,{{3,18382}}}, -- Bloodvine Garb
	[441] = {{19685,19687,19686},2,3,65,0,{{3,24090}}}, -- Primal Batskin
	[442] = {{19689,19688},2,3,65,0,{{2,18384},{2,7597}}}, -- Blood Tiger Harness
	[443] = {{19691,19690,19692},3,3,65,0,{{3,21636}}}, -- Bloodsoul Embrace
	[444] = {{19695,19693,19694},4,3,65,0,{{3,21416}}}, -- The Darksoul
	[461] = {{19865,19866},0,4,67,0,{{2,15763}}}, -- The Twin Blades of Hakkari
	[462] = {{19893,19905},0,3,70,0,{{2,9396},{2,23727}}}, -- Zanzil's Concentration
	[463] = {{19896,19910},0,4,65,0,{{2,24256}}}, -- Primal Blessing
	[464] = {{19912,19873},0,3,70,0,{{2,13669}}}, -- Overlord's Resolution
	[465] = {{19920,19863},0,3,70,0,{{2,9318}}}, -- Prayer of the Primal
	[466] = {{19925,19898},0,3,68,0,{{2,9336}}}, -- Major Mojo Infusion
	[467] = {{20057,20041,20048},4,3,64,3,{{2,7503},{3,7597}}}, -- The Highlander's Resolution
	[468] = {{20058,20042,20049},4,3,64,2,{{2,7503},{3,7597}}}, -- The Highlander's Resolve
	[469] = {{20055,20043,20050},3,3,64,4,{{2,7503},{3,7597}}}, -- The Highlander's Determination
	[470] = {{20056,20044,20051},3,3,64,4,{{2,7503},{3,18384}}}, -- The Highlander's Fortitude
	[471] = {{20059,20045,20052},2,3,64,1032,{{2,7503},{3,7597}}}, -- The Highlander's Purpose
	[472] = {{20060,20046,20053},2,3,64,1032,{{2,7503},{3,18384}}}, -- The Highlander's Will
	[473] = {{20061,20047,20054},1,3,64,400,{{2,7503},{3,18384}}}, -- The Highlander's Intent
	[474] = {{19577,19822,19824,19823,19951},4,4,63,1,{{2,13675},{3,24456},{5,24431}}}, -- Vindicator's Battlegear
	[475] = {{19588,19825,19827,19826,19952},4,4,63,2,{{2,21618},{3,24457},{5,24460}}}, -- Freethinker's Armor
	[476] = {{19609,19828,19830,19829,19956},3,4,63,64,{{2,21618},{3,24461},{5,24462}}}, -- Augur's Regalia
	[477] = {{19621,19831,19833,19832,19953},3,4,64,4,{{2,9331},{3,24465},{5,24467}}}, -- Predator's Armor
	[478] = {{19617,19835,19834,19836,19954},2,4,63,8,{{2,9331},{3,24469},{5,24471}}}, -- Madcap's Outfit
	[479] = {{19613,19838,19840,19839,19955},2,4,63,1024,{{2,21618},{3,24479},{5,24480}}}, -- Haruspex's Garb
	[480] = {{19594,19841,19843,19842,19958},1,4,64,16,{{2,9408},{3,24482},{5,24483}}}, -- Confessor's Raiment
	[481] = {{19605,19849,20033,19848,19957},1,4,63,256,{{2,9417},{3,24486},{5,24487}}}, -- Demoniac's Threads
	[482] = {{19601,19845,20034,19846,19959},1,4,63,128,{{2,9417},{3,24489},{5,24491}}}, -- Illusionist's Attire
	[483] = {{20158,20150,20154},3,3,64,68,{{2,7503},{3,7597}}}, -- The Defiler's Determination
	[484] = {{20203,20195,20199},3,3,64,68,{{2,7503},{3,7597}}}, -- The Defiler's Fortitude
	[485] = {{20176,20163,20159},1,3,64,400,{{2,7503},{3,18384}}}, -- The Defiler's Intent
	[486] = {{20194,20190,20186},2,3,64,1032,{{2,7503},{3,7597}}}, -- The Defiler's Purpose
	[487] = {{20212,20204,20208},4,3,64,1,{{2,7503},{3,7597}}}, -- The Defiler's Resolution
	[488] = {{20175,20171,20167},2,3,64,1032,{{2,7503},{3,18384}}}, -- The Defiler's Will
	[489] = {{15051,15050,15052,16984},3,3,60,0,{{2,15464},{3,7598},{4,14590}}}, -- Black Dragon Mail
	[490] = {{15045,20296,15046},3,3,54,0,{{2,21625},{3,21894}}}, -- Green Dragon Mail
	[491] = {{15049,15048,20295},3,3,59,0,{{2,18675},{3,14127}}}, -- Blue Dragon Mail
	[492] = {{20408,20406,20407},1,2,60,32767,{{3,24746}}}, -- Twilight Trappings
	[493] = {{21353,21354,21357,21356,21355},2,4,81,1024,{{3,15693},{3,18196},{5,26106}}}, -- Genesis Raiment
	[494] = {{21409,21408,21407},0,4,67,1024,{{3,26107}}}, -- Symbols of Unending Life
	[495] = {{21394,21393,21392},0,4,67,1,{{3,26111}}}, -- Battlegear of Unyielding Strength
	[496] = {{21329,21330,21331,21332,21333},4,4,81,1,{{3,26109},{5,26110}}}, -- Conqueror's Battlegear
	[497] = {{21360,21361,21364,21362,21359},2,4,81,8,{{3,26112},{5,26113}}}, -- Deathdealer's Embrace
	[498] = {{21406,21405,21404},0,4,67,8,{{3,26114}}}, -- Emblems of Veiled Shadows
	[499] = {{21337,21335,21334,21336,21338},1,4,81,256,{{3,26116},{5,26117}}}, -- Doomcaller's Attire
	[500] = {{21418,21417,21416},0,4,67,256,{{3,26118}}}, -- Implements of Unspoken Names
	[501] = {{21372,21376,21374,21375,21373},3,4,81,64,{{3,26119},{5,26122}}}, -- Stormcaller's Garb
	[502] = {{21400,21399,21398},0,4,67,64,{{3,26123}}}, -- Gift of the Gathering Storm
	[503] = {{21347,21345,21343,21346,21344},1,4,81,128,{{3,26127},{5,26128}}}, -- Enigma Vestments
	[504] = {{21415,21414,21413},0,4,67,128,{{3,26131}}}, -- Trappings of Vaulted Secrets
	[505] = {{21387,21391,21389,21390,21388},4,4,81,2,{{3,26130},{5,23929}}}, -- Avenger's Battlegear
	[506] = {{21397,21396,21395},0,4,67,2,{{3,26135}}}, -- Battlegear of Eternal Justice
	[507] = {{21348,21350,21351,21352,21349},1,4,81,16,{{3,26169},{5,26171}}}, -- Garments of the Oracle
	[508] = {{21412,21411,21410},0,4,67,16,{{3,26172}}}, -- Finery of Infinite Wisdom
	[509] = {{21366,21367,21370,21368,21365},3,4,82,4,{{3,26173},{5,26174}}}, -- Striker's Garb
	[510] = {{21403,21402,21401},0,4,67,4,{{3,26176}}}, -- Trappings of the Unseen Path
	[511] = {{21999,22001,21997,21996,21998,21994,22000,21995},4,3,62,0,{{2,18679},{4,27419},{6,14049},{8,14803}}}, -- Battlegear of Heroism
	[512] = {{22005,22008,22009,22004,22006,22002,22007,22003},2,3,62,0,{{2,18679},{4,27787},{6,14049},{8,14803}}}, -- Darkmantle Armor
	[513] = {{22109,22112,22113,22108,22110,22106,22111,22107},2,3,62,0,{{2,18679},{4,27781},{6,9344},{6,9334},{8,14803}}}, -- Feralheart Raiment
	[514] = {{22080,22082,22083,22079,22081,22078,22085,22084},1,3,62,0,{{2,18679},{4,27778},{6,14047},{8,14803}}}, -- Vestments of the Virtuous
	[515] = {{22013,22016,22060,22011,22015,22010,22017,22061},3,3,62,0,{{2,18679},{4,27785},{6,14049},{8,14803}}}, -- Beastmaster Armor
	[516] = {{22091,22093,22089,22088,22090,22086,22092,22087},4,3,62,0,{{2,18679},{4,27498},{6,14049},{8,14803}}}, -- Soulforge Armor
	[517] = {{22065,22068,22069,22063,22066,22062,22067,22064},1,3,62,0,{{2,18679},{4,27867},{6,14047},{8,14803}}}, -- Sorcerer's Regalia
	[518] = {{22074,22073,22075,22071,22077,22070,22072,22076},1,3,62,0,{{2,18679},{4,27780},{6,14047},{8,14803}}}, -- Deathmist Raiment
	[519] = {{22097,22101,22102,22095,22099,22098,22100,22096},3,3,62,0,{{2,18679},{4,27774},{6,14047},{8,14803}}}, -- The Five Thunders
	[520] = {{22302,22305,22301,22313,22304,22306,22303,22311},1,3,62,400,{{4,27733},{8,14803}}}, -- Ironweave Battlesuit
	[521] = {{22490,22491,22488,22495,22493,22494,22489,22492,23064},2,4,88,1024,{{2,28716},{4,28743},{6,28744},{8,28719}}}, -- Dreamwalker Raiment
	[522] = {{23257,23258,22879,22864,22880,22856},2,3,68,8,{{2,14049},{4,23048},{6,14467}}}, -- Champion's Guard
	[523] = {{22418,22419,22416,22423,22421,22422,22417,22420,23059},4,4,88,1,{{2,28844},{4,28843},{6,28842},{8,28845}}}, -- Dreadnaught's Battlegear
	[524] = {{22478,22479,22476,22483,22481,22482,22477,22480,23060},2,4,88,8,{{2,28816},{4,28812},{6,28811},{8,28814}}}, -- Bonescythe Armor
	[525] = {{22514,22515,22512,22519,22517,22518,22513,22516,23061},1,4,88,16,{{2,28807},{4,28809},{6,28808},{8,28802}}}, -- Vestments of Faith
	[526] = {{22498,22499,22496,22503,22501,22502,22497,22500,23062},1,4,88,128,{{2,28763},{4,28764},{6,28771},{8,28761}}}, -- Frostfire Regalia
	[527] = {{22466,22467,22464,22471,22469,22470,22465,22468,23065},3,4,88,64,{{2,28818},{4,29171},{6,28823},{8,28821}}}, -- The Earthshatterer
	[528] = {{22428,22429,22425,22424,22426,22431,22427,22430,23066},4,4,88,2,{{2,28775},{4,28774},{6,28789},{8,28787}}}, -- Redemption Armor
	[529] = {{22506,22507,22504,22511,22509,22510,22505,22508,23063},1,4,88,256,{{2,28831},{4,28829},{6,28746},{8,28830}}}, -- Plagueheart Raiment
	[530] = {{22438,22439,22436,22443,22441,22442,22437,22440,23067},3,4,88,4,{{2,28755},{4,28756},{6,28752},{8,28751}}}, -- Cryptstalker Armor
	[533] = {{23087,23090,23078},4,3,63,1535,{{3,29068}}}, -- Battlegear of Undead Slaying
	[534] = {{23089,23093,23081},2,3,63,1535,{{3,29068}}}, -- Undead Slayer's Armor
	[535] = {{23088,23092,23082},3,3,63,32767,{{3,29068}}}, -- Garb of the Undead Slayer
	[536] = {{23085,23091,23084},1,3,63,32767,{{3,29068}}}, -- Regalia of Undead Cleansing
	[537] = {{23244,23243,22872,22868,22873,22858},4,3,68,1,{{2,14049},{4,22738},{6,14467}}}, -- Champion's Battlearmor
	[538] = {{23259,23260,22876,22867,22887,22857},3,3,68,64,{{2,14049},{4,22804},{6,14467}}}, -- Champion's Stormcaller
	[539] = {{23253,23254,22877,22863,22878,22852},2,3,68,1024,{{2,14049},{4,23218},{6,14467}}}, -- Champion's Refuge
	[540] = {{23261,23262,22885,22869,22882,22859},1,3,68,16,{{2,14047},{4,23044},{6,14467}}}, -- Champion's Investiture
	[541] = {{23255,23256,22884,22865,22881,22855},1,3,68,256,{{2,14047},{4,23047},{6,14467}}}, -- Champion's Dreadgear
	[542] = {{23263,23264,22886,22870,22883,22860},1,3,68,128,{{2,14047},{4,23025},{6,14467}}}, -- Champion's Arcanum
	[543] = {{23251,23252,22874,22862,22875,22843},3,3,68,4,{{2,14384},{4,23158},{6,14467}}}, -- Champion's Pursuance
	[544] = {{23276,23277,23272,23274,23273,23275},4,3,68,2,{{2,14047},{4,23302},{6,14467}}}, -- Lieutenant Commander's Redoubt
	[545] = {{23314,23315,23300,23286,23301,23287},4,3,68,1,{{2,14049},{4,22738},{6,14467}}}, -- Lieutenant Commander's Battlearmor
	[546] = {{23318,23319,23305,23290,23304,23291},1,3,68,128,{{2,14047},{4,23025},{6,14467}}}, -- Lieutenant Commander's Arcanum
	[547] = {{23310,23311,23297,23282,23296,23283},1,3,68,256,{{2,14047},{4,23047},{6,14467}}}, -- Lieutenant Commander's Dreadgear
	[548] = {{23312,23313,23298,23284,23299,23285},2,3,68,8,{{2,14049},{4,23048},{6,14467}}}, -- Lieutenant Commander's Guard
	[549] = {{23316,23317,23303,23288,23302,23289},1,3,68,16,{{2,14047},{4,23044},{6,14467}}}, -- Lieutenant Commander's Investiture
	[550] = {{23306,23307,23292,23279,23293,23278},3,3,68,4,{{2,14384},{4,23158},{6,14467}}}, -- Lieutenant Commander's Pursuance
	[551] = {{23308,23309,23294,23280,23295,23281},2,3,68,1024,{{2,14049},{4,23218},{6,14467}}}, -- Lieutenant Commander's Refuge
--@version-bcc@
	[142] = {{15058,15056,21278,15057},2,3,57,32767,{{2,18979},{3,23863},{4,41845}}}, -- Stormshroud Armor
	[162] = {{6473,10413,10412,10410,10411},2,3,22,0,{{2,41740},{3,41739},{4,41644},{5,41741}}}, -- Embrace of the Viper
	[469] = {{20055,20043,20050},3,3,64,68,{{2,41865},{3,39418}}}, -- The Highlander's Determination
	[470] = {{20056,20044,20051},3,3,64,68,{{2,41638},{3,39447}}}, -- The Highlander's Fortitude
	[487] = {{20212,20204,20208},4,3,64,3,{{2,41853},{3,39486}}}, -- The Defiler's Resolution
	[552] = {{21848,21847,21846},1,4,105,32767,{{3,32196}}}, -- Wrath of Spellfire
	[553] = {{21869,21871,21870},1,4,105,32767,{{3,39372}}}, -- Shadow's Embrace
	[554] = {{21874,21875,21873},1,4,113,32767,{{3,32102}}}, -- Primal Mooncloth
	[555] = {{21854,21855,21849,21851,21850,21852,21853},1,2,103,0,{{2,39543},{4,41829}}}, -- Netherweave Vestments
	[556] = {{21861,21862,21859,21860},1,3,111,32767,{{3,39881}}}, -- Imbued Netherweave
	[557] = {{21864,21865,21863},1,4,100,32767,{{3,41841}}}, -- Soulcloth Embrace
	[558] = {{21868,21866,21867},1,3,114,32767,{{3,41658}}}, -- Arcanoweave Vestments
	[559] = {{24266,24262},1,4,105,0,{{2,32106}}}, -- Spellstrike Infusion
	[560] = {{23489,23482,23484,23488,23487},4,2,95,32767,{{2,42155},{4,41744}}}, -- Fel Iron Plate
	[561] = {{23493,23490,23494,23491},3,2,95,32767,{{2,41561},{4,41562}}}, -- Fel Iron Chain
	[562] = {{23507,23506,23508},4,3,104,32767,{{3,41655}}}, -- Adamantite Battlegear
	[563] = {{23509,23510,23512,23511},4,3,114,0,{{3,41742}}}, -- Enchanted Adamantite Armor
	[564] = {{23516,23513,23515,23514},4,3,114,0,{{3,41769}}}, -- Flame Guard
	[565] = {{23524,23523,23525},4,3,114,32767,{{3,41783}}}, -- Khorium Ward
	[566] = {{23521,33173,23522,23520},4,3,115,0,{{2,41678}}}, -- Burning Rage
	[567] = {{24545,24546,24544,24549,24547},4,4,123,1,{{2,32145},{4,22738}}}, -- Gladiator's Battlegear
	[568] = {{24553,24554,24552,24556,24555},1,4,123,256,{{2,40042},{4,23047}}}, -- Gladiator's Dreadgear
	[569] = {{23519,23517,23518},4,3,114,0,{{3,41743}}}, -- Faith in Felsteel
	[570] = {{24249,24255},1,3,109,32767,{{2,41876}}}, -- The Unyielding
	[571] = {{24264,24261},1,4,105,0,{{2,32200}}}, -- Whitemend Wisdom
	[572] = {{24267,24263},1,4,105,0,{{2,41660}}}, -- Battlecast Garb
	[573] = {{25685,25687,25686},2,3,110,0,{{3,41746}}}, -- Fel Skin
	[574] = {{25689,25690,25691},2,3,113,0,{{3,41846}}}, -- Strength of the Clefthoof
	[575] = {{25696,25697,25695},3,3,113,0,{{3,41749}}}, -- Felstalker Armor
	[576] = {{25694,25692,25693},3,3,104,0,{{3,41771}}}, -- Fury of the Nether
	[577] = {{25830,25832,25831,25834,25833},2,4,123,8,{{2,32145},{4,21975}}}, -- Gladiator's Vestments
	[578] = {{25998,25999,25997,26000,26001},3,4,123,64,{{2,32145},{4,33018}}}, -- Gladiator's Earthshaker
	[579] = {{25855,25854,25856,25857,25858},1,4,123,128,{{2,40042},{4,44302}}}, -- Gladiator's Regalia
	[580] = {{27471,27473,27469,27470,27472},3,4,123,64,{{2,40042},{4,44296}}}, -- Gladiator's Thunderfist
	[581] = {{27708,27710,27711,27707,27709},1,4,123,16,{{2,40042},{4,33333}}}, -- Gladiator's Raiment
	[582] = {{27704,27706,27702,27703,27705},4,4,123,2,{{2,40044},{4,23302}}}, -- Gladiator's Aegis
	[583] = {{27881,27883,27879,27880,27882},4,4,123,2,{{2,32145},{4,23302}}}, -- Gladiator's Vindication
	[584] = {{28127,28129,28130,28126,28128},2,4,123,1024,{{2,32145},{4,23218}}}, -- Gladiator's Sanctuary
	[585] = {{28137,28139,28140,28136,28138},2,4,123,1024,{{2,40042},{4,46832}}}, -- Gladiator's Wildhide
	[586] = {{28331,28333,28334,28335,28332},3,4,123,4,{{2,32145},{4,44292}}}, -- Gladiator's Pursuit
	[587] = {{28833,28835,28831,28832,28834},4,3,115,2,{{2,40052},{4,23302}}}, -- High Warlord's Aegis
	[588] = {{28853,28855,28851,28852,28854},4,3,115,1,{{2,40050},{4,22738}}}, -- High Warlord's Battlegear
	[589] = {{28681,28683,28679,28680,28724},4,3,115,2,{{2,40048},{4,23302}}}, -- Grand Marshal's Aegis
	[590] = {{28701,28703,28699,28700,28702},4,3,115,1,{{2,40046},{4,22738}}}, -- Grand Marshal's Battlegear
	[591] = {{28625,28627,28628,28624,28626},1,3,115,256,{{2,40047},{4,23047}}}, -- Grand Marshal's Dreadgear
	[592] = {{28818,28820,28821,28817,28819},1,3,115,256,{{2,40051},{4,23047}}}, -- High Warlord's Dreadgear
	[593] = {{28691,28693,28689,28690,28692},3,3,115,64,{{2,40046},{4,33018}}}, -- Grand Marshal's Earthshaker
	[594] = {{28843,28845,28841,28842,28844},3,3,115,64,{{2,40050},{4,33018}}}, -- High Warlord's Earthshaker
	[595] = {{28615,28617,28613,28614,28616},3,3,115,4,{{2,40046},{4,23158}}}, -- Grand Marshal's Pursuit
	[596] = {{28807,28809,28805,28806,28808},3,3,115,4,{{2,40050},{4,23158}}}, -- High Warlord's Pursuit
	[597] = {{28705,28707,28708,28704,28706},1,3,115,16,{{2,40047},{4,33333}}}, -- Grand Marshal's Raiment
	[598] = {{28857,28859,28860,28856,28858},1,3,115,16,{{2,40051},{4,33333}}}, -- High Warlord's Raiment
	[599] = {{28715,28714,28717,28716,28718},1,3,115,128,{{2,40047},{4,23025}}}, -- Grand Marshal's Regalia
	[600] = {{28867,28866,28869,28868,28870},1,3,115,128,{{2,40051},{4,23025}}}, -- High Warlord's Regalia
	[601] = {{28619,28622,28623,28618,28620},2,3,115,1024,{{2,40046},{4,23218}}}, -- Grand Marshal's Sanctuary
	[602] = {{28812,28814,28815,28811,28813},2,3,115,1024,{{2,40050},{4,23218}}}, -- High Warlord's Sanctuary
	[603] = {{28696,28698,28694,28695,28697},3,3,115,64,{{2,40047},{4,22804}}}, -- Grand Marshal's Thunderfist
	[604] = {{28848,28850,28846,28847,28849},3,3,115,64,{{2,40051},{4,22804}}}, -- High Warlord's Thunderfist
	[605] = {{28685,28687,28688,28684,28686},2,3,115,8,{{2,40046},{4,23048}}}, -- Grand Marshal's Vestments
	[606] = {{28837,28839,28840,28836,28838},2,3,115,8,{{2,40050},{4,23048}}}, -- High Warlord's Vestments
	[607] = {{28711,28713,28709,28710,28712},4,3,115,2,{{2,40046},{4,23302}}}, -- Grand Marshal's Vindication
	[608] = {{28863,28865,28861,28862,28864},4,3,115,2,{{2,40050},{4,23302}}}, -- High Warlord's Vindication
	[609] = {{28720,28722,28723,28719,28721},2,3,115,1024,{{2,40047},{4,33877}}}, -- Grand Marshal's Wildhide
	[610] = {{28872,28874,28875,28871,28873},2,3,115,1024,{{2,40051},{4,33877}}}, -- High Warlord's Wildhide
	[611] = {{25657,25654,25656,25655},3,2,96,0,{{2,41748},{4,41747}}}, -- Felscale Armor
	[612] = {{25660,25661,25662,25659},3,2,97,0,{{2,41833},{4,41834}}}, -- Scaled Draenic Armor
	[613] = {{25671,25669,25670,25668},2,2,96,0,{{2,41878},{4,41877}}}, -- Thick Draenic Armor
	[614] = {{25676,25674,25675,25673},2,2,95,0,{{2,41890},{4,41889}}}, -- Wild Draenish Armor
	[615] = {{30187,30186,30200,30188,30201},1,4,123,256,{{2,40053},{4,23047}}}, -- Gladiator's Felshroud
	[616] = {{29515,29517,29516},3,4,113,0,{{3,39982}}}, -- Netherscale Armor
	[617] = {{29519,29521,29520},3,4,117,0,{{3,41828}}}, -- Netherstrike Armor
	[618] = {{29522,29523,29524},2,4,117,0,{{3,41591}}}, -- Windhawk Armor
	[619] = {{29525,29527,29526},2,4,117,0,{{3,41832}}}, -- Primal Intent
	[620] = {{28414,27776,28204,27509,27908},2,3,115,32767,{{2,37165},{4,37166}}}, -- Assassination Armor
	[621] = {{29044,29047,29045,29048,29046},2,4,120,8,{{2,37167},{4,37168}}}, -- Netherblade
	[622] = {{30146,30149,30144,30145,30148},2,4,133,8,{{2,37169},{4,37170}}}, -- Deathmantle
	[623] = {{28285,27739,28203,27535,27839},4,3,115,0,{{2,37180},{4,37181}}}, -- Righteous Armor
	[624] = {{29061,29064,29062,29065,29063},4,4,120,2,{{2,37182},{4,37183}}}, -- Justicar Raiment
	[625] = {{29068,29070,29066,29067,29069},4,4,120,2,{{2,37184},{4,37185}}}, -- Justicar Armor
	[626] = {{29073,29075,29071,29072,29074},4,4,120,2,{{2,37186},{4,37187}}}, -- Justicar Battlegear
	[627] = {{30136,30138,30134,30135,30137},4,4,133,2,{{2,37188},{4,37189}}}, -- Crystalforge Raiment
	[628] = {{30125,30127,30123,30124,30126},4,4,133,2,{{2,37190},{4,37191}}}, -- Crystalforge Armor
	[629] = {{30131,30133,30129,30130,30132},4,4,133,2,{{2,37194},{4,37195}}}, -- Crystalforge Battlegear
	[630] = {{28349,27802,28231,27510,27909},3,3,115,0,{{2,37207},{4,37209}}}, -- Tidefury Raiment
	[631] = {{29028,29031,29029,29032,29030},3,4,120,64,{{2,37210},{4,37211}}}, -- Cyclone Raiment
	[632] = {{29035,29037,29033,29034,29036},3,4,120,64,{{2,37212},{4,37213}}}, -- Cyclone Regalia
	[633] = {{29040,29043,29038,29039,29042},3,4,120,64,{{2,37223},{4,37224}}}, -- Cyclone Harness
	[634] = {{30166,30168,30164,30165,30167},3,4,133,64,{{2,37225},{4,37227}}}, -- Cataclysm Raiment
	[635] = {{30171,30173,30169,30170,30172},3,4,133,64,{{2,37228},{4,37237}}}, -- Cataclysm Regalia
	[636] = {{30190,30194,30185,30189,30192},3,4,133,64,{{2,37239},{4,37241}}}, -- Cataclysm Harness
	[637] = {{28348,27737,28202,27468,27873},2,3,115,0,{{2,37286},{4,37287}}}, -- Moonglade Raiment
	[638] = {{29086,29089,29087,29090,29088},2,4,120,1024,{{2,37288},{4,37292}}}, -- Malorne Raiment
	[639] = {{29093,29095,29091,29092,29094},2,4,120,1024,{{2,37295},{4,37297}}}, -- Malorne Regalia
	[640] = {{29098,29100,29096,29097,29099},2,4,120,1024,{{2,37311},{2,37306},{4,37299},{4,37298}}}, -- Malorne Harness
	[641] = {{30228,30230,30222,30223,30229},2,4,133,1024,{{2,37315},{4,37333}}}, -- Nordrassil Harness
	[642] = {{30219,30221,30216,30217,30220},2,4,133,1024,{{2,37313},{4,37314}}}, -- Nordrassil Raiment
	[643] = {{30233,30235,30231,30232,30234},2,4,133,1024,{{2,37324},{4,37327}}}, -- Nordrassil Regalia
	[644] = {{28415,27778,28232,27537,27948},1,3,115,32767,{{2,37375},{4,37376}}}, -- Oblivion Raiment
	[645] = {{28963,28967,28964,28968,28966},1,4,120,256,{{2,39437},{2,37377},{4,37380}}}, -- Voidheart Raiment
	[646] = {{30212,30215,30214,30211,30213},1,4,133,256,{{2,37381},{4,37384}}}, -- Corruptor Raiment
	[647] = {{28278,27738,28229,27508,27838},1,3,115,32767,{{2,37423},{4,37424}}}, -- Incanter's Regalia
	[648] = {{29076,29079,29077,29080,29078},1,4,120,128,{{2,37438},{4,37439}}}, -- Aldor Regalia
	[649] = {{30206,30210,30196,30205,30207},1,4,133,128,{{2,37441},{4,37443}}}, -- Tirisfal Regalia
	[650] = {{28275,27801,28228,27474,27874},3,3,115,0,{{2,37481},{4,37483}}}, -- Beast Lord Armor
	[651] = {{29081,29084,29082,29085,29083},3,4,120,4,{{2,37484},{4,37485}}}, -- Demon Stalker Armor
	[652] = {{30141,30143,30139,30140,30142},3,4,133,4,{{2,37381},{4,37505}}}, -- Rift Stalker Armor
	[653] = {{28350,27803,28205,27475,27977},4,3,115,32767,{{2,37512},{4,37513}}}, -- Bold Armor
	[654] = {{29011,29016,29012,29017,29015},4,4,120,1,{{2,37514},{4,37516}}}, -- Warbringer Armor
	[655] = {{29021,29023,29019,29020,29022},4,4,120,1,{{2,37518},{4,37519}}}, -- Warbringer Battlegear
	[656] = {{30115,30117,30113,30114,30116},4,4,133,1,{{2,37522},{4,37525}}}, -- Destroyer Armor
	[657] = {{30120,30122,30118,30119,30121},4,4,133,1,{{2,37528},{4,37535}}}, -- Destroyer Battlegear
	[658] = {{28193,27796,28191,27465,27907},1,3,115,32767,{{2,37607},{4,37619}}}, -- Mana-Etched Regalia
	[659] = {{28224,27797,28264,27531,27837},2,3,115,32767,{{2,37608},{4,37618}}}, -- Wastewalker Armor
	[660] = {{28192,27713,28401,27528,27936},3,3,115,0,{{2,37609},{4,37617}}}, -- Desolation Battlegear
	[661] = {{28225,27771,28403,27497,27870},4,3,115,32767,{{2,37610},{4,37611}}}, -- Doomplate Battlegear
	[662] = {{28413,27775,28230,27536,27875},1,3,115,32767,{{2,37556},{4,37558}}}, -- Hallowed Raiment
	[663] = {{29049,29054,29050,29055,29053},1,4,120,16,{{2,37564},{4,37568}}}, -- Incarnate Raiment
	[664] = {{29058,29060,29056,29057,29059},1,4,120,16,{{2,37570},{4,37571}}}, -- Incarnate Regalia
	[665] = {{30152,30154,30150,30151,30153},1,4,133,16,{{2,37594},{4,26171}}}, -- Avatar Raiment
	[666] = {{30161,30163,30159,30160,30162},1,4,133,16,{{2,37600},{4,37603}}}, -- Avatar Regalia
	[667] = {{31338,31339},0,4,100,0,{{2,41875}}}, -- The Twin Stars
	[668] = {{31027,31030,31028,34448,31026,34558,31029,34575},2,4,149,8,{{2,38388},{4,38389}}}, -- Slayer's Armor
	[669] = {{31003,31006,31004,34443,31001,34549,31005,34570},3,4,149,4,{{2,38390},{4,38392}}}, -- Gronnstalker's Armor
	[670] = {{31051,31054,31052,34436,31050,34541,31053,34564},1,4,149,256,{{2,38394},{4,38393}}}, -- Malefic Raiment
	[671] = {{31056,31059,31057,34447,31055,34557,31058,34574},1,4,149,128,{{2,38396},{4,38397}}}, -- Tempest Regalia
	[672] = {{30972,30979,30975,34441,30969,34546,30977,34569},4,4,149,1,{{2,38398},{4,38399}}}, -- Onslaught Battlegear
	[673] = {{30974,30980,30976,34442,30970,34547,30978,34568},4,4,149,1,{{2,38408},{4,38407}}}, -- Onslaught Armor
	[674] = {{31064,31070,31065,34434,31061,34528,31067,34563},1,4,149,16,{{2,38413},{4,38412}}}, -- Absolution Regalia
	[675] = {{31063,31069,31066,34435,31060,34527,31068,34562},1,4,149,16,{{2,38410},{4,38411}}}, -- Vestments of Absolution
	[676] = {{31039,31048,31042,34444,31034,34556,31044,34573},2,4,149,1024,{{2,38447},{4,38416}}}, -- Thunderheart Harness
	[677] = {{31040,31049,31043,34446,31035,34555,31046,34572},2,4,149,1024,{{2,38414},{4,38415}}}, -- Thunderheart Regalia
	[678] = {{31037,31047,31041,34445,31032,34554,31045,34571},2,4,149,1024,{{2,38417},{4,38420}}}, -- Thunderheart Raiment
	[679] = {{30987,30998,30991,34433,30985,34488,30995,34560},4,4,149,2,{{2,38421},{4,38422}}}, -- Lightbringer Armor
	[680] = {{30989,30997,30990,34431,30982,34485,30993,34561},4,4,149,2,{{2,38427},{4,38424}}}, -- Lightbringer Battlegear
	[681] = {{30988,30996,30992,34432,30983,34487,30994,34559},4,4,149,2,{{2,38426},{4,38425}}}, -- Lightbringer Raiment
	[682] = {{31015,31024,31018,34439,31011,34545,31021,34567},3,4,149,64,{{2,38429},{4,38432}}}, -- Skyshatter Harness
	[683] = {{31012,31022,31016,34438,31007,34543,31019,34565},3,4,149,64,{{2,38434},{4,38435}}}, -- Skyshatter Raiment
	[684] = {{31014,31023,31017,34437,31008,34542,31020,34566},3,4,149,64,{{2,38443},{4,38436}}}, -- Skyshatter Regalia
	[685] = {{31376,31378,31379,31375,31377},2,4,123,1024,{{2,40043},{4,46834}}}, -- Gladiator's Refuge
	[686] = {{31400,31407,31396,31397,31406},3,4,123,64,{{2,40043},{4,44299}}}, -- Gladiator's Wartide
	[687] = {{31410,31412,31413,31409,31411},1,4,123,16,{{2,40043},{4,33333}}}, -- Gladiator's Investiture
	[688] = {{31590,31592,31593,31589,31591},2,3,115,1024,{{2,40045},{4,46834}}}, -- Grand Marshal's Refuge
	[689] = {{31585,31587,31588,31584,31586},2,3,115,1024,{{2,40049},{4,46834}}}, -- High Warlord's Refuge
	[690] = {{31616,31619,31613,31614,31618},4,4,123,2,{{2,40043},{4,46851}}}, -- Gladiator's Redemption
	[691] = {{31622,31624,31625,31620,31623},1,3,115,16,{{2,40045},{4,33333}}}, -- Grand Marshal's Investiture
	[692] = {{31626,31628,31629,31621,31627},1,3,115,16,{{2,40049},{4,33333}}}, -- High Warlord's Investiture
	[693] = {{31632,31634,31630,31631,31633},4,3,115,2,{{2,40045},{4,46851}}}, -- Grand Marshal's Redemption
	[694] = {{31637,31639,31635,31636,31638},4,3,115,2,{{2,40049},{4,46851}}}, -- High Warlord's Redemption
	[695] = {{31642,31644,31640,31641,31643},3,3,115,64,{{2,40045},{4,38499}}}, -- Grand Marshal's Wartide
	[696] = {{31648,31650,31646,31647,31649},3,3,115,64,{{2,40049},{4,38499}}}, -- High Warlord's Wartide
	[697] = {{29604,29605,29602,29600,29603,29601},4,3,68,2,{{2,41705},{3,23302},{6,41704}}}, -- Champion's Redoubt
	[698] = {{29616,29617,29615,29613,29614,29612},4,4,73,2,{{2,41886},{3,23302},{6,30778}}}, -- Warlord's Aegis
	[699] = {{32837,32838},0,5,156,9,{{2,41433},{2,41434}}}, -- The Twin Blades of Azzinoth
	[700] = {{31997,31996,31992,31993,31995},4,4,136,2,{{2,41462},{4,23302}}}, -- Merciless Gladiator's Aegis
	[701] = {{30488,30490,30486,30487,30489},4,4,136,1,{{2,41464},{4,22738}}}, -- Merciless Gladiator's Battlegear
	[702] = {{31974,31976,31977,31973,31975},1,4,136,256,{{2,41474},{4,23047}}}, -- Merciless Gladiator's Dreadgear
	[703] = {{32006,32008,32004,32005,32007},3,4,136,64,{{2,41464},{4,33018}}}, -- Merciless Gladiator's Earthshaker
	[704] = {{31980,31979,31982,31981,31983},1,4,136,256,{{2,41462},{4,23047}}}, -- Merciless Gladiator's Felshroud
	[705] = {{32016,32018,32019,32015,32017},1,4,136,16,{{2,41463},{4,33333}}}, -- Merciless Gladiator's Investiture
	[706] = {{31962,31964,31960,31961,31963},3,4,136,4,{{2,41464},{4,44292}}}, -- Merciless Gladiator's Pursuit
	[707] = {{32035,32037,32038,32034,32036},1,4,136,16,{{2,41462},{4,33333}}}, -- Merciless Gladiator's Raiment
	[708] = {{32022,32024,32020,32021,32023},4,4,136,2,{{2,41463},{4,46851}}}, -- Merciless Gladiator's Redemption
	[709] = {{31988,31990,31991,31987,31989},2,4,136,1024,{{2,41463},{4,23218}}}, -- Merciless Gladiator's Refuge
	[710] = {{32048,32047,32050,32049,32051},1,4,136,128,{{2,41462},{4,44302}}}, -- Merciless Gladiator's Regalia
	[711] = {{31968,31971,31972,31967,31969},2,4,136,1024,{{2,41464},{4,23218}}}, -- Merciless Gladiator's Sanctuary
	[712] = {{32011,32013,32009,32010,32012},3,4,136,64,{{2,41462},{4,44296}}}, -- Merciless Gladiator's Thunderfist
	[713] = {{31999,32001,32002,31998,32000},2,4,136,8,{{2,41464},{4,21975}}}, -- Merciless Gladiator's Vestments
	[714] = {{32041,32043,32039,32040,32042},4,4,136,2,{{2,41464},{4,23302}}}, -- Merciless Gladiator's Vindication
	[715] = {{32031,32033,32029,32030,32032},3,4,136,64,{{2,41463},{4,44299}}}, -- Merciless Gladiator's Wartide
	[716] = {{32057,32059,32060,32056,32058},2,4,136,1024,{{2,41462},{4,44293}}}, -- Merciless Gladiator's Wildhide
	[717] = {{29610,29611,29609,29607,29608,29606},3,4,73,64,{{2,41896},{3,22804},{6,41895}}}, -- Field Marshal's Earthshaker
	[718] = {{29598,29599,29596,29595,29597,29594},3,3,68,64,{{2,41713},{4,22804},{6,41712}}}, -- Lieutenant Commander's Earthshaker
	[719] = {{32946,32945},0,4,141,0,{{2,41989}}}, -- The Fists of Fury
	[720] = {{33691,33693,33694,33690,33692},2,4,146,1024,{{2,43478},{4,23218}}}, -- Vengeful Gladiator's Refuge
	[721] = {{33672,33674,33675,33671,33673},2,4,146,1024,{{2,43479},{4,23218}}}, -- Vengeful Gladiator's Sanctuary
	[722] = {{33768,33770,33771,33767,33769},2,4,146,1024,{{2,43480},{4,44293}}}, -- Vengeful Gladiator's Wildhide
	[723] = {{33666,33668,33664,33665,33667},3,4,146,4,{{2,43479},{4,44292}}}, -- Vengeful Gladiator's Pursuit
	[724] = {{33758,33757,33760,33759,33761},1,4,146,128,{{2,43480},{4,44302}}}, -- Vengeful Gladiator's Regalia
	[725] = {{33724,33726,33722,33723,33725},4,4,146,2,{{2,43478},{4,23302}}}, -- Vengeful Gladiator's Redemption
	[726] = {{33751,33753,33749,33750,33752},4,4,146,2,{{2,43479},{4,23302}}}, -- Vengeful Gladiator's Vindication
	[727] = {{33697,33699,33695,33696,33698},4,4,146,2,{{2,43480},{4,23302}}}, -- Vengeful Gladiator's Aegis
	[728] = {{33718,33720,33721,33717,33719},1,4,146,16,{{2,43478},{4,33333}}}, -- Vengeful Gladiator's Investiture
	[729] = {{33745,33747,33748,33744,33746},1,4,146,16,{{2,43480},{4,33333}}}, -- Vengeful Gladiator's Raiment
	[730] = {{33701,33703,33704,33700,33702},2,4,146,8,{{2,43479},{4,21975}}}, -- Vengeful Gladiator's Vestments
	[731] = {{33740,33742,33738,33739,33741},3,4,146,64,{{2,43478},{4,44299}}}, -- Vengeful Gladiator's Wartide
	[732] = {{33708,33710,33706,33707,33709},3,4,146,64,{{2,43479},{4,33018}}}, -- Vengeful Gladiator's Earthshaker
	[733] = {{33713,33715,33711,33712,33714},3,4,146,64,{{2,43480},{4,44296}}}, -- Vengeful Gladiator's Thunderfist
	[734] = {{33677,33679,33680,33676,33678},1,4,146,256,{{2,43481},{4,23047}}}, -- Vengeful Gladiator's Dreadgear
	[735] = {{33683,33682,33685,33684,33686},1,4,146,256,{{2,43480},{4,23047}}}, -- Vengeful Gladiator's Felshroud
	[736] = {{33730,33732,33728,33729,33731},4,4,146,1,{{2,43479},{4,22738}}}, -- Vengeful Gladiator's Battlegear
	[737] = {{28189,34703},0,3,115,0,{{2,9336}}}, -- Latro's Flurry
	[738] = {{35329,35331,35332,35328,35330},1,3,115,256,{{2,46412},{4,23047}}}, -- Dreadweave Battlegear
	[739] = {{35333,35336,35337,35335,35334},1,3,115,16,{{2,46413},{4,33333}}}, -- Mooncloth Battlegear
	[740] = {{35339,35341,35342,35338,35340},1,3,115,16,{{2,46414},{4,33333}}}, -- Satin Battlegear
	[741] = {{35344,35343,35346,35345,35347},1,3,115,128,{{2,46415},{4,23025}}}, -- Evoker's Silk Battlegear
	[742] = {{35357,35359,35360,35356,35358},2,3,115,1024,{{2,46435},{4,23218}}}, -- Dragonhide Battlegear
	[743] = {{35372,35374,35375,35371,35373},2,3,115,1024,{{2,46436},{4,46832}}}, -- Wyrmhide Battlegear
	[744] = {{35362,35364,35365,35361,35363},2,3,115,1024,{{2,46437},{4,46834}}}, -- Kodohide Battlegear
	[745] = {{35367,35369,35370,35366,35368},2,3,115,8,{{2,46438},{4,23048}}}, -- Opportunist's Battlegear
	[746] = {{35388,35390,35386,35387,35389},3,3,115,64,{{2,46454},{4,22804}}}, -- Seer's Mail Battlegear
	[747] = {{35393,35395,35391,35392,35394},3,3,115,64,{{2,46455},{4,38466}}}, -- Seer's Ringmail Battlegear
	[748] = {{35383,35385,35381,35382,35384},3,3,115,64,{{2,46456},{4,33018}}}, -- Seer's Linked Battlegear
	[749] = {{35378,35380,35376,35377,35379},3,3,115,4,{{2,46456},{4,23158}}}, -- Stalker's Chain Battlegear
	[750] = {{35409,35411,35407,35408,35410},4,3,115,1,{{2,46528},{4,22738}}}, -- Savage Plate Battlegear
	[751] = {{35404,35406,35402,35403,35405},4,3,115,2,{{2,46530},{4,23302}}}, -- Crusader's Ornamented Battlegear
	[752] = {{35414,35416,35412,35413,35415},4,3,115,2,{{2,46534},{4,23302}}}, -- Crusader's Scaled Battlegear
	[200567] = {{35068,35070,35066,35067,35069},4,4,159,1,{{2,32145},{4,22738}},AL["Brutal Gladiator's Battlegear"]}, -- Brutal Gladiator's Battlegear
	[200568] = {{35004,35006,35007,35003,35005},1,4,159,256,{{2,40042},{4,23047}},AL["Brutal Gladiator's Dreadgear"]}, -- Brutal Gladiator's Dreadgear
	[200577] = {{35033,35035,35036,35032,35034},2,4,159,8,{{2,32145},{4,21975}},AL["Brutal Gladiator's Vestments"]}, -- Brutal Gladiator's Vestments
	[200578] = {{35044,35046,35042,35043,35045},3,4,159,64,{{2,32145},{4,33018}},AL["Brutal Gladiator's Earthshaker"]}, -- Brutal Gladiator's Earthshaker
	[200579] = {{35097,35096,35099,35098,35100},1,4,159,128,{{2,40042},{4,44302}},AL["Brutal Gladiator's Regalia"]}, -- Brutal Gladiator's Regalia
	[200580] = {{35050,35052,35048,35049,35051},3,4,159,64,{{2,40042},{4,44296}},AL["Brutal Gladiator's Thunderfist"]}, -- Brutal Gladiator's Thunderfist
	[200581] = {{35084,35086,35087,35083,35085},1,4,159,16,{{2,40042},{4,33333}},AL["Brutal Gladiator's Raiment"]}, -- Brutal Gladiator's Raiment
	[200582] = {{35029,35031,35027,35028,35030},4,4,159,2,{{2,40044},{4,23302}},AL["Brutal Gladiator's Aegis"]}, -- Brutal Gladiator's Aegis
	[200583] = {{35090,35092,35088,35089,35091},4,4,159,2,{{2,32145},{4,23302}},AL["Brutal Gladiator's Vindication"]}, -- Brutal Gladiator's Vindication
	[200584] = {{34999,35001,35002,34998,35000},2,4,159,1024,{{2,32145},{4,23218}},AL["Brutal Gladiator's Sanctuary"]}, -- Brutal Gladiator's Sanctuary
	[200585] = {{35112,35114,35115,35111,35113},2,4,159,1024,{{2,40042},{4,46832}},AL["Brutal Gladiator's Wildhide"]}, -- Brutal Gladiator's Wildhide
	[200586] = {{34992,34994,34990,34991,34993},3,4,159,4,{{2,32145},{4,44292}},AL["Brutal Gladiator's Pursuit"]}, -- Brutal Gladiator's Pursuit
	[200615] = {{35010,35009,35012,35011,35013},1,4,159,256,{{2,40053},{4,23047}},AL["Brutal Gladiator's Felshroud"]}, -- Brutal Gladiator's Felshroud
	[200685] = {{35023,35025,35026,35022,35024},2,4,159,1024,{{2,40043},{4,46834}},AL["Brutal Gladiator's Refuge"]}, -- Brutal Gladiator's Refuge
	[200686] = {{35079,35081,35077,35078,35080},3,4,159,64,{{2,40043},{4,44299}},AL["Brutal Gladiator's Wartide"]}, -- Brutal Gladiator's Wartide
	[200687] = {{35054,35056,35057,35053,35055},1,4,159,16,{{2,40043},{4,33333}},AL["Brutal Gladiator's Investiture"]}, -- Brutal Gladiator's Investiture
	[200690] = {{35061,35063,35059,35060,35062},4,4,159,2,{{2,40043},{4,46851}},AL["Brutal Gladiator's Redemption"]}, -- Brutal Gladiator's Redemption
--@end-version-bcc@
}

local ITEM_TO_SET = {
	-- [itemID] = setID
	[6473]=162,[7948]=221,[7949]=221,[7950]=221,[7951]=221,[7952]=221,[7953]=221,[10328]=163,[10329]=163,
	[10330]=163,[10331]=163,[10332]=163,[10333]=163,[10399]=161,[10400]=161,[10401]=161,[10402]=161,[10403]=161,
	[10410]=162,[10411]=162,[10412]=162,[10413]=162,[11726]=1,[11728]=1,[11729]=1,[11730]=1,[11731]=1,
	[12422]=321,[12424]=321,[12425]=321,[12426]=321,[12427]=321,[12428]=321,[12429]=321,[12939]=41,[12940]=41,
	[13183]=65,[13218]=65,[13388]=81,[13389]=81,[13390]=81,[13391]=81,[13392]=81,[14611]=123,[14612]=123,
	[14614]=123,[14615]=123,[14616]=123,[14620]=124,[14621]=124,[14622]=124,[14623]=124,[14624]=124,[14626]=122,
	[14629]=122,[14631]=122,[14632]=122,[14633]=122,[14636]=121,[14637]=121,[14638]=121,[14640]=121,[14641]=121,
	[15045]=490,[15046]=490,[15048]=491,[15049]=491,[15050]=489,[15051]=489,[15052]=489,[15053]=141,[15054]=141,
	[15055]=141,[15056]=142,[15057]=142,[15058]=142,[15062]=143,[15063]=143,[15066]=144,[15067]=144,[16369]=343,
	[16391]=343,[16392]=348,[16393]=381,[16396]=348,[16397]=381,[16401]=362,[16403]=362,[16405]=282,[16406]=282,
	[16409]=401,[16410]=401,[16413]=343,[16414]=343,[16415]=343,[16416]=343,[16417]=348,[16418]=348,[16419]=348,
	[16420]=348,[16421]=381,[16422]=381,[16423]=381,[16424]=381,[16425]=362,[16426]=362,[16427]=362,[16428]=362,
	[16429]=282,[16430]=282,[16431]=282,[16432]=282,[16433]=401,[16434]=401,[16435]=401,[16436]=401,[16437]=388,
	[16440]=388,[16441]=388,[16442]=388,[16443]=388,[16444]=388,[16446]=394,[16448]=397,[16449]=397,[16450]=397,
	[16451]=397,[16452]=397,[16453]=394,[16454]=394,[16455]=394,[16456]=394,[16457]=394,[16459]=397,[16462]=395,
	[16463]=395,[16465]=395,[16466]=395,[16467]=395,[16468]=395,[16471]=402,[16472]=402,[16473]=402,[16474]=402,
	[16475]=402,[16476]=402,[16477]=384,[16478]=384,[16479]=384,[16480]=384,[16483]=384,[16484]=384,[16485]=341,
	[16487]=341,[16489]=341,[16490]=341,[16491]=341,[16492]=341,[16494]=382,[16496]=382,[16498]=347,[16499]=347,
	[16501]=382,[16502]=382,[16503]=382,[16504]=382,[16505]=347,[16506]=347,[16507]=347,[16508]=347,[16509]=281,
	[16510]=281,[16513]=281,[16514]=281,[16515]=281,[16516]=281,[16518]=301,[16519]=301,[16521]=301,[16522]=301,
	[16523]=301,[16524]=301,[16525]=361,[16526]=361,[16527]=361,[16528]=361,[16530]=361,[16531]=361,[16533]=387,
	[16534]=387,[16535]=387,[16536]=387,[16539]=387,[16540]=387,[16541]=383,[16542]=383,[16543]=383,[16544]=383,
	[16545]=383,[16548]=383,[16549]=398,[16550]=398,[16551]=398,[16552]=398,[16554]=398,[16555]=398,[16558]=393,
	[16560]=393,[16561]=393,[16562]=393,[16563]=393,[16564]=393,[16565]=396,[16566]=396,[16567]=396,[16568]=396,
	[16569]=396,[16571]=396,[16573]=386,[16574]=386,[16577]=386,[16578]=386,[16579]=386,[16580]=386,[16666]=187,
	[16667]=187,[16668]=187,[16669]=187,[16670]=187,[16671]=187,[16672]=187,[16673]=187,[16674]=186,[16675]=186,
	[16676]=186,[16677]=186,[16678]=186,[16679]=186,[16680]=186,[16681]=186,[16682]=181,[16683]=181,[16684]=181,
	[16685]=181,[16686]=181,[16687]=181,[16688]=181,[16689]=181,[16690]=182,[16691]=182,[16692]=182,[16693]=182,
	[16694]=182,[16695]=182,[16696]=182,[16697]=182,[16698]=183,[16699]=183,[16700]=183,[16701]=183,[16702]=183,
	[16703]=183,[16704]=183,[16705]=183,[16706]=185,[16707]=184,[16708]=184,[16709]=184,[16710]=184,[16711]=184,
	[16712]=184,[16713]=184,[16714]=185,[16715]=185,[16716]=185,[16717]=185,[16718]=185,[16719]=185,[16720]=185,
	[16721]=184,[16722]=188,[16723]=188,[16724]=188,[16725]=188,[16726]=188,[16727]=188,[16728]=188,[16729]=188,
	[16730]=189,[16731]=189,[16732]=189,[16733]=189,[16734]=189,[16735]=189,[16736]=189,[16737]=189,[16795]=201,
	[16796]=201,[16797]=201,[16798]=201,[16799]=201,[16800]=201,[16801]=201,[16802]=201,[16803]=203,[16804]=203,
	[16805]=203,[16806]=203,[16807]=203,[16808]=203,[16809]=203,[16810]=203,[16811]=202,[16812]=202,[16813]=202,
	[16814]=202,[16815]=202,[16816]=202,[16817]=202,[16818]=210,[16819]=202,[16820]=204,[16821]=204,[16822]=204,
	[16823]=204,[16824]=204,[16825]=204,[16826]=204,[16827]=204,[16828]=205,[16829]=205,[16830]=205,[16831]=205,
	[16832]=213,[16833]=205,[16834]=205,[16835]=205,[16836]=205,[16837]=207,[16838]=207,[16839]=207,[16840]=207,
	[16841]=207,[16842]=207,[16843]=207,[16844]=207,[16845]=206,[16846]=206,[16847]=206,[16848]=206,[16849]=206,
	[16850]=206,[16851]=206,[16852]=206,[16853]=208,[16854]=208,[16855]=208,[16856]=208,[16857]=208,[16858]=208,
	[16859]=208,[16860]=208,[16861]=209,[16862]=209,[16863]=209,[16864]=209,[16865]=209,[16866]=209,[16867]=209,
	[16868]=209,[16897]=214,[16898]=214,[16899]=214,[16900]=214,[16901]=214,[16902]=214,[16903]=214,[16904]=214,
	[16905]=213,[16906]=213,[16907]=213,[16908]=213,[16909]=213,[16910]=213,[16911]=213,[16912]=210,[16913]=210,
	[16914]=210,[16915]=210,[16916]=210,[16917]=210,[16918]=210,[16919]=211,[16920]=211,[16921]=211,[16922]=211,
	[16923]=211,[16924]=211,[16925]=211,[16926]=211,[16927]=212,[16928]=212,[16929]=212,[16930]=212,[16931]=212,
	[16932]=212,[16933]=212,[16934]=212,[16935]=215,[16936]=215,[16937]=215,[16938]=215,[16939]=215,[16940]=215,
	[16941]=215,[16942]=215,[16943]=216,[16944]=216,[16945]=216,[16946]=216,[16947]=216,[16948]=216,[16949]=216,
	[16950]=216,[16951]=217,[16952]=217,[16953]=217,[16954]=217,[16955]=217,[16956]=217,[16957]=217,[16958]=217,
	[16959]=218,[16960]=218,[16961]=218,[16962]=218,[16963]=218,[16964]=218,[16965]=218,[16966]=218,[16984]=489,
	[17064]=241,[17082]=241,[17562]=346,[17564]=346,[17566]=346,[17567]=346,[17568]=346,[17569]=346,[17570]=345,
	[17571]=345,[17572]=345,[17573]=345,[17576]=345,[17577]=345,[17578]=392,[17579]=392,[17580]=392,[17581]=392,
	[17583]=392,[17584]=392,[17586]=391,[17588]=391,[17590]=391,[17591]=391,[17592]=391,[17593]=391,[17594]=344,
	[17596]=344,[17598]=344,[17599]=344,[17600]=344,[17601]=344,[17602]=389,[17603]=389,[17604]=389,[17605]=389,
	[17607]=389,[17608]=389,[17610]=342,[17611]=342,[17612]=342,[17613]=342,[17616]=342,[17617]=342,[17618]=390,
	[17620]=390,[17622]=390,[17623]=390,[17624]=390,[17625]=390,[18202]=261,[18203]=261,[18204]=261,[18205]=261,
	[19577]=474,[19588]=475,[19594]=480,[19601]=482,[19605]=481,[19609]=476,[19613]=479,[19617]=478,[19621]=477,
	[19682]=421,[19683]=421,[19684]=421,[19685]=441,[19686]=441,[19687]=441,[19688]=442,[19689]=442,[19690]=443,
	[19691]=443,[19692]=443,[19693]=444,[19694]=444,[19695]=444,[19822]=474,[19823]=474,[19824]=474,[19825]=475,
	[19826]=475,[19827]=475,[19828]=476,[19829]=476,[19830]=476,[19831]=477,[19832]=477,[19833]=477,[19834]=478,
	[19835]=478,[19836]=478,[19838]=479,[19839]=479,[19840]=479,[19841]=480,[19842]=480,[19843]=480,[19845]=482,
	[19846]=482,[19848]=481,[19849]=481,[19863]=465,[19865]=461,[19866]=461,[19873]=464,[19893]=462,[19896]=463,
	[19898]=466,[19905]=462,[19910]=463,[19912]=464,[19920]=465,[19925]=466,[19951]=474,[19952]=475,[19953]=477,
	[19954]=478,[19955]=479,[19956]=476,[19957]=481,[19958]=480,[19959]=482,[20033]=481,[20034]=482,[20041]=467,
	[20042]=468,[20043]=469,[20044]=470,[20045]=471,[20046]=472,[20047]=473,[20048]=467,[20049]=468,[20050]=469,
	[20051]=470,[20052]=471,[20053]=472,[20054]=473,[20055]=469,[20056]=470,[20057]=467,[20058]=468,[20059]=471,
	[20060]=472,[20061]=473,[20150]=483,[20154]=483,[20158]=483,[20159]=485,[20163]=485,[20167]=488,[20171]=488,
	[20175]=488,[20176]=485,[20186]=486,[20190]=486,[20194]=486,[20195]=484,[20199]=484,[20203]=484,[20204]=487,
	[20208]=487,[20212]=487,[20295]=491,[20296]=490,[20406]=492,[20407]=492,[20408]=492,[21278]=142,[21329]=496,
	[21330]=496,[21331]=496,[21332]=496,[21333]=496,[21334]=499,[21335]=499,[21336]=499,[21337]=499,[21338]=499,
	[21343]=503,[21344]=503,[21345]=503,[21346]=503,[21347]=503,[21348]=507,[21349]=507,[21350]=507,[21351]=507,
	[21352]=507,[21353]=493,[21354]=493,[21355]=493,[21356]=493,[21357]=493,[21359]=497,[21360]=497,[21361]=497,
	[21362]=497,[21364]=497,[21365]=509,[21366]=509,[21367]=509,[21368]=509,[21370]=509,[21372]=501,[21373]=501,
	[21374]=501,[21375]=501,[21376]=501,[21387]=505,[21388]=505,[21389]=505,[21390]=505,[21391]=505,[21392]=495,
	[21393]=495,[21394]=495,[21395]=506,[21396]=506,[21397]=506,[21398]=502,[21399]=502,[21400]=502,[21401]=510,
	[21402]=510,[21403]=510,[21404]=498,[21405]=498,[21406]=498,[21407]=494,[21408]=494,[21409]=494,[21410]=508,
	[21411]=508,[21412]=508,[21413]=504,[21414]=504,[21415]=504,[21416]=500,[21417]=500,[21418]=500,[21994]=511,
	[21995]=511,[21996]=511,[21997]=511,[21998]=511,[21999]=511,[22000]=511,[22001]=511,[22002]=512,[22003]=512,
	[22004]=512,[22005]=512,[22006]=512,[22007]=512,[22008]=512,[22009]=512,[22010]=515,[22011]=515,[22013]=515,
	[22015]=515,[22016]=515,[22017]=515,[22060]=515,[22061]=515,[22062]=517,[22063]=517,[22064]=517,[22065]=517,
	[22066]=517,[22067]=517,[22068]=517,[22069]=517,[22070]=518,[22071]=518,[22072]=518,[22073]=518,[22074]=518,
	[22075]=518,[22076]=518,[22077]=518,[22078]=514,[22079]=514,[22080]=514,[22081]=514,[22082]=514,[22083]=514,
	[22084]=514,[22085]=514,[22086]=516,[22087]=516,[22088]=516,[22089]=516,[22090]=516,[22091]=516,[22092]=516,
	[22093]=516,[22095]=519,[22096]=519,[22097]=519,[22098]=519,[22099]=519,[22100]=519,[22101]=519,[22102]=519,
	[22106]=513,[22107]=513,[22108]=513,[22109]=513,[22110]=513,[22111]=513,[22112]=513,[22113]=513,[22301]=520,
	[22302]=520,[22303]=520,[22304]=520,[22305]=520,[22306]=520,[22311]=520,[22313]=520,[22416]=523,[22417]=523,
	[22418]=523,[22419]=523,[22420]=523,[22421]=523,[22422]=523,[22423]=523,[22424]=528,[22425]=528,[22426]=528,
	[22427]=528,[22428]=528,[22429]=528,[22430]=528,[22431]=528,[22436]=530,[22437]=530,[22438]=530,[22439]=530,
	[22440]=530,[22441]=530,[22442]=530,[22443]=530,[22464]=527,[22465]=527,[22466]=527,[22467]=527,[22468]=527,
	[22469]=527,[22470]=527,[22471]=527,[22476]=524,[22477]=524,[22478]=524,[22479]=524,[22480]=524,[22481]=524,
	[22482]=524,[22483]=524,[22488]=521,[22489]=521,[22490]=521,[22491]=521,[22492]=521,[22493]=521,[22494]=521,
	[22495]=521,[22496]=526,[22497]=526,[22498]=526,[22499]=526,[22500]=526,[22501]=526,[22502]=526,[22503]=526,
	[22504]=529,[22505]=529,[22506]=529,[22507]=529,[22508]=529,[22509]=529,[22510]=529,[22511]=529,[22512]=525,
	[22513]=525,[22514]=525,[22515]=525,[22516]=525,[22517]=525,[22518]=525,[22519]=525,[22843]=543,[22852]=539,
	[22855]=541,[22856]=522,[22857]=538,[22858]=537,[22859]=540,[22860]=542,[22862]=543,[22863]=539,[22864]=522,
	[22865]=541,[22867]=538,[22868]=537,[22869]=540,[22870]=542,[22872]=537,[22873]=537,[22874]=543,[22875]=543,
	[22876]=538,[22877]=539,[22878]=539,[22879]=522,[22880]=522,[22881]=541,[22882]=540,[22883]=542,[22884]=541,
	[22885]=540,[22886]=542,[22887]=538,[23059]=523,[23060]=524,[23061]=525,[23062]=526,[23063]=529,[23064]=521,
	[23065]=527,[23066]=528,[23067]=530,[23078]=533,[23081]=534,[23082]=535,[23084]=536,[23085]=536,[23087]=533,
	[23088]=535,[23089]=534,[23090]=533,[23091]=536,[23092]=535,[23093]=534,[23243]=537,[23244]=537,[23251]=543,
	[23252]=543,[23253]=539,[23254]=539,[23255]=541,[23256]=541,[23257]=522,[23258]=522,[23259]=538,[23260]=538,
	[23261]=540,[23262]=540,[23263]=542,[23264]=542,[23272]=544,[23273]=544,[23274]=544,[23275]=544,[23276]=544,
	[23277]=544,[23278]=550,[23279]=550,[23280]=551,[23281]=551,[23282]=547,[23283]=547,[23284]=548,[23285]=548,
	[23286]=545,[23287]=545,[23288]=549,[23289]=549,[23290]=546,[23291]=546,[23292]=550,[23293]=550,[23294]=551,
	[23295]=551,[23296]=547,[23297]=547,[23298]=548,[23299]=548,[23300]=545,[23301]=545,[23302]=549,[23303]=549,
	[23304]=546,[23305]=546,[23306]=550,[23307]=550,[23308]=551,[23309]=551,[23310]=547,[23311]=547,[23312]=548,
	[23313]=548,[23314]=545,[23315]=545,[23316]=549,[23317]=549,[23318]=546,[23319]=546,
--@version-bcc@
	[21846]=552,[21847]=552,[21848]=552,[21849]=555,[21850]=555,[21851]=555,[21852]=555,[21853]=555,[21854]=555,
	[21855]=555,[21859]=556,[21860]=556,[21861]=556,[21862]=556,[21863]=557,[21864]=557,[21865]=557,[21866]=558,
	[21867]=558,[21868]=558,[21869]=553,[21870]=553,[21871]=553,[21873]=554,[21874]=554,[21875]=554,[23482]=560,
	[23484]=560,[23487]=560,[23488]=560,[23489]=560,[23490]=561,[23491]=561,[23493]=561,[23494]=561,[23506]=562,
	[23507]=562,[23508]=562,[23509]=563,[23510]=563,[23511]=563,[23512]=563,[23513]=564,[23514]=564,[23515]=564,
	[23516]=564,[23517]=569,[23518]=569,[23519]=569,[23520]=566,[23521]=566,[23522]=566,[23523]=565,[23524]=565,
	[23525]=565,[24249]=570,[24255]=570,[24261]=571,[24262]=559,[24263]=572,[24264]=571,[24266]=559,[24267]=572,
	[24544]=567,[24545]=567,[24546]=567,[24547]=567,[24549]=567,[24552]=568,[24553]=568,[24554]=568,[24555]=568,
	[24556]=568,[25654]=611,[25655]=611,[25656]=611,[25657]=611,[25659]=612,[25660]=612,[25661]=612,[25662]=612,
	[25668]=613,[25669]=613,[25670]=613,[25671]=613,[25673]=614,[25674]=614,[25675]=614,[25676]=614,[25685]=573,
	[25686]=573,[25687]=573,[25689]=574,[25690]=574,[25691]=574,[25692]=576,[25693]=576,[25694]=576,[25695]=575,
	[25696]=575,[25697]=575,[25830]=577,[25831]=577,[25832]=577,[25833]=577,[25834]=577,[25854]=579,[25855]=579,
	[25856]=579,[25857]=579,[25858]=579,[25997]=578,[25998]=578,[25999]=578,[26000]=578,[26001]=578,[27465]=658,
	[27468]=637,[27469]=580,[27470]=580,[27471]=580,[27472]=580,[27473]=580,[27474]=650,[27475]=653,[27497]=661,
	[27508]=647,[27509]=620,[27510]=630,[27528]=660,[27531]=659,[27535]=623,[27536]=662,[27537]=644,[27702]=582,
	[27703]=582,[27704]=582,[27705]=582,[27706]=582,[27707]=581,[27708]=581,[27709]=581,[27710]=581,[27711]=581,
	[27713]=660,[27737]=637,[27738]=647,[27739]=623,[27771]=661,[27775]=662,[27776]=620,[27778]=644,[27796]=658,
	[27797]=659,[27801]=650,[27802]=630,[27803]=653,[27837]=659,[27838]=647,[27839]=623,[27870]=661,[27873]=637,
	[27874]=650,[27875]=662,[27879]=583,[27880]=583,[27881]=583,[27882]=583,[27883]=583,[27907]=658,[27908]=620,
	[27909]=630,[27936]=660,[27948]=644,[27977]=653,[28126]=584,[28127]=584,[28128]=584,[28129]=584,[28130]=584,
	[28136]=585,[28137]=585,[28138]=585,[28139]=585,[28140]=585,[28189]=737,[28191]=658,[28192]=660,[28193]=658,
	[28202]=637,[28203]=623,[28204]=620,[28205]=653,[28224]=659,[28225]=661,[28228]=650,[28229]=647,[28230]=662,
	[28231]=630,[28232]=644,[28264]=659,[28275]=650,[28278]=647,[28285]=623,[28331]=586,[28332]=586,[28333]=586,
	[28334]=586,[28335]=586,[28348]=637,[28349]=630,[28350]=653,[28401]=660,[28403]=661,[28413]=662,[28414]=620,
	[28415]=644,[28613]=595,[28614]=595,[28615]=595,[28616]=595,[28617]=595,[28618]=601,[28619]=601,[28620]=601,
	[28622]=601,[28623]=601,[28624]=591,[28625]=591,[28626]=591,[28627]=591,[28628]=591,[28679]=589,[28680]=589,
	[28681]=589,[28683]=589,[28684]=605,[28685]=605,[28686]=605,[28687]=605,[28688]=605,[28689]=593,[28690]=593,
	[28691]=593,[28692]=593,[28693]=593,[28694]=603,[28695]=603,[28696]=603,[28697]=603,[28698]=603,[28699]=590,
	[28700]=590,[28701]=590,[28702]=590,[28703]=590,[28704]=597,[28705]=597,[28706]=597,[28707]=597,[28708]=597,
	[28709]=607,[28710]=607,[28711]=607,[28712]=607,[28713]=607,[28714]=599,[28715]=599,[28716]=599,[28717]=599,
	[28718]=599,[28719]=609,[28720]=609,[28721]=609,[28722]=609,[28723]=609,[28724]=589,[28805]=596,[28806]=596,
	[28807]=596,[28808]=596,[28809]=596,[28811]=602,[28812]=602,[28813]=602,[28814]=602,[28815]=602,[28817]=592,
	[28818]=592,[28819]=592,[28820]=592,[28821]=592,[28831]=587,[28832]=587,[28833]=587,[28834]=587,[28835]=587,
	[28836]=606,[28837]=606,[28838]=606,[28839]=606,[28840]=606,[28841]=594,[28842]=594,[28843]=594,[28844]=594,
	[28845]=594,[28846]=604,[28847]=604,[28848]=604,[28849]=604,[28850]=604,[28851]=588,[28852]=588,[28853]=588,
	[28854]=588,[28855]=588,[28856]=598,[28857]=598,[28858]=598,[28859]=598,[28860]=598,[28861]=608,[28862]=608,
	[28863]=608,[28864]=608,[28865]=608,[28866]=600,[28867]=600,[28868]=600,[28869]=600,[28870]=600,[28871]=610,
	[28872]=610,[28873]=610,[28874]=610,[28875]=610,[28963]=645,[28964]=645,[28966]=645,[28967]=645,[28968]=645,
	[29011]=654,[29012]=654,[29015]=654,[29016]=654,[29017]=654,[29019]=655,[29020]=655,[29021]=655,[29022]=655,
	[29023]=655,[29028]=631,[29029]=631,[29030]=631,[29031]=631,[29032]=631,[29033]=632,[29034]=632,[29035]=632,
	[29036]=632,[29037]=632,[29038]=633,[29039]=633,[29040]=633,[29042]=633,[29043]=633,[29044]=621,[29045]=621,
	[29046]=621,[29047]=621,[29048]=621,[29049]=663,[29050]=663,[29053]=663,[29054]=663,[29055]=663,[29056]=664,
	[29057]=664,[29058]=664,[29059]=664,[29060]=664,[29061]=624,[29062]=624,[29063]=624,[29064]=624,[29065]=624,
	[29066]=625,[29067]=625,[29068]=625,[29069]=625,[29070]=625,[29071]=626,[29072]=626,[29073]=626,[29074]=626,
	[29075]=626,[29076]=648,[29077]=648,[29078]=648,[29079]=648,[29080]=648,[29081]=651,[29082]=651,[29083]=651,
	[29084]=651,[29085]=651,[29086]=638,[29087]=638,[29088]=638,[29089]=638,[29090]=638,[29091]=639,[29092]=639,
	[29093]=639,[29094]=639,[29095]=639,[29096]=640,[29097]=640,[29098]=640,[29099]=640,[29100]=640,[29515]=616,
	[29516]=616,[29517]=616,[29519]=617,[29520]=617,[29521]=617,[29522]=618,[29523]=618,[29524]=618,[29525]=619,
	[29526]=619,[29527]=619,[29594]=718,[29595]=718,[29596]=718,[29597]=718,[29598]=718,[29599]=718,[29600]=697,
	[29601]=697,[29602]=697,[29603]=697,[29604]=697,[29605]=697,[29606]=717,[29607]=717,[29608]=717,[29609]=717,
	[29610]=717,[29611]=717,[29612]=698,[29613]=698,[29614]=698,[29615]=698,[29616]=698,[29617]=698,[30113]=656,
	[30114]=656,[30115]=656,[30116]=656,[30117]=656,[30118]=657,[30119]=657,[30120]=657,[30121]=657,[30122]=657,
	[30123]=628,[30124]=628,[30125]=628,[30126]=628,[30127]=628,[30129]=629,[30130]=629,[30131]=629,[30132]=629,
	[30133]=629,[30134]=627,[30135]=627,[30136]=627,[30137]=627,[30138]=627,[30139]=652,[30140]=652,[30141]=652,
	[30142]=652,[30143]=652,[30144]=622,[30145]=622,[30146]=622,[30148]=622,[30149]=622,[30150]=665,[30151]=665,
	[30152]=665,[30153]=665,[30154]=665,[30159]=666,[30160]=666,[30161]=666,[30162]=666,[30163]=666,[30164]=634,
	[30165]=634,[30166]=634,[30167]=634,[30168]=634,[30169]=635,[30170]=635,[30171]=635,[30172]=635,[30173]=635,
	[30185]=636,[30186]=615,[30187]=615,[30188]=615,[30189]=636,[30190]=636,[30192]=636,[30194]=636,[30196]=649,
	[30200]=615,[30201]=615,[30205]=649,[30206]=649,[30207]=649,[30210]=649,[30211]=646,[30212]=646,[30213]=646,
	[30214]=646,[30215]=646,[30216]=642,[30217]=642,[30219]=642,[30220]=642,[30221]=642,[30222]=641,[30223]=641,
	[30228]=641,[30229]=641,[30230]=641,[30231]=643,[30232]=643,[30233]=643,[30234]=643,[30235]=643,[30486]=701,
	[30487]=701,[30488]=701,[30489]=701,[30490]=701,[30969]=672,[30970]=673,[30972]=672,[30974]=673,[30975]=672,
	[30976]=673,[30977]=672,[30978]=673,[30979]=672,[30980]=673,[30982]=680,[30983]=681,[30985]=679,[30987]=679,
	[30988]=681,[30989]=680,[30990]=680,[30991]=679,[30992]=681,[30993]=680,[30994]=681,[30995]=679,[30996]=681,
	[30997]=680,[30998]=679,[31001]=669,[31003]=669,[31004]=669,[31005]=669,[31006]=669,[31007]=683,[31008]=684,
	[31011]=682,[31012]=683,[31014]=684,[31015]=682,[31016]=683,[31017]=684,[31018]=682,[31019]=683,[31020]=684,
	[31021]=682,[31022]=683,[31023]=684,[31024]=682,[31026]=668,[31027]=668,[31028]=668,[31029]=668,[31030]=668,
	[31032]=678,[31034]=676,[31035]=677,[31037]=678,[31039]=676,[31040]=677,[31041]=678,[31042]=676,[31043]=677,
	[31044]=676,[31045]=678,[31046]=677,[31047]=678,[31048]=676,[31049]=677,[31050]=670,[31051]=670,[31052]=670,
	[31053]=670,[31054]=670,[31055]=671,[31056]=671,[31057]=671,[31058]=671,[31059]=671,[31060]=675,[31061]=674,
	[31063]=675,[31064]=674,[31065]=674,[31066]=675,[31067]=674,[31068]=675,[31069]=675,[31070]=674,[31338]=667,
	[31339]=667,[31375]=685,[31376]=685,[31377]=685,[31378]=685,[31379]=685,[31396]=686,[31397]=686,[31400]=686,
	[31406]=686,[31407]=686,[31409]=687,[31410]=687,[31411]=687,[31412]=687,[31413]=687,[31584]=689,[31585]=689,
	[31586]=689,[31587]=689,[31588]=689,[31589]=688,[31590]=688,[31591]=688,[31592]=688,[31593]=688,[31613]=690,
	[31614]=690,[31616]=690,[31618]=690,[31619]=690,[31620]=691,[31621]=692,[31622]=691,[31623]=691,[31624]=691,
	[31625]=691,[31626]=692,[31627]=692,[31628]=692,[31629]=692,[31630]=693,[31631]=693,[31632]=693,[31633]=693,
	[31634]=693,[31635]=694,[31636]=694,[31637]=694,[31638]=694,[31639]=694,[31640]=695,[31641]=695,[31642]=695,
	[31643]=695,[31644]=695,[31646]=696,[31647]=696,[31648]=696,[31649]=696,[31650]=696,[31960]=706,[31961]=706,
	[31962]=706,[31963]=706,[31964]=706,[31967]=711,[31968]=711,[31969]=711,[31971]=711,[31972]=711,[31973]=702,
	[31974]=702,[31975]=702,[31976]=702,[31977]=702,[31979]=704,[31980]=704,[31981]=704,[31982]=704,[31983]=704,
	[31987]=709,[31988]=709,[31989]=709,[31990]=709,[31991]=709,[31992]=700,[31993]=700,[31995]=700,[31996]=700,
	[31997]=700,[31998]=713,[31999]=713,[32000]=713,[32001]=713,[32002]=713,[32004]=703,[32005]=703,[32006]=703,
	[32007]=703,[32008]=703,[32009]=712,[32010]=712,[32011]=712,[32012]=712,[32013]=712,[32015]=705,[32016]=705,
	[32017]=705,[32018]=705,[32019]=705,[32020]=708,[32021]=708,[32022]=708,[32023]=708,[32024]=708,[32029]=715,
	[32030]=715,[32031]=715,[32032]=715,[32033]=715,[32034]=707,[32035]=707,[32036]=707,[32037]=707,[32038]=707,
	[32039]=714,[32040]=714,[32041]=714,[32042]=714,[32043]=714,[32047]=710,[32048]=710,[32049]=710,[32050]=710,
	[32051]=710,[32056]=716,[32057]=716,[32058]=716,[32059]=716,[32060]=716,[32837]=699,[32838]=699,[32945]=719,
	[32946]=719,[33173]=566,[33664]=723,[33665]=723,[33666]=723,[33667]=723,[33668]=723,[33671]=721,[33672]=721,
	[33673]=721,[33674]=721,[33675]=721,[33676]=734,[33677]=734,[33678]=734,[33679]=734,[33680]=734,[33682]=735,
	[33683]=735,[33684]=735,[33685]=735,[33686]=735,[33690]=720,[33691]=720,[33692]=720,[33693]=720,[33694]=720,
	[33695]=727,[33696]=727,[33697]=727,[33698]=727,[33699]=727,[33700]=730,[33701]=730,[33702]=730,[33703]=730,
	[33704]=730,[33706]=732,[33707]=732,[33708]=732,[33709]=732,[33710]=732,[33711]=733,[33712]=733,[33713]=733,
	[33714]=733,[33715]=733,[33717]=728,[33718]=728,[33719]=728,[33720]=728,[33721]=728,[33722]=725,[33723]=725,
	[33724]=725,[33725]=725,[33726]=725,[33728]=736,[33729]=736,[33730]=736,[33731]=736,[33732]=736,[33738]=731,
	[33739]=731,[33740]=731,[33741]=731,[33742]=731,[33744]=729,[33745]=729,[33746]=729,[33747]=729,[33748]=729,
	[33749]=726,[33750]=726,[33751]=726,[33752]=726,[33753]=726,[33757]=724,[33758]=724,[33759]=724,[33760]=724,
	[33761]=724,[33767]=722,[33768]=722,[33769]=722,[33770]=722,[33771]=722,[34431]=680,[34432]=681,[34433]=679,
	[34434]=674,[34435]=675,[34436]=670,[34437]=684,[34438]=683,[34439]=682,[34441]=672,[34442]=673,[34443]=669,
	[34444]=676,[34445]=678,[34446]=677,[34447]=671,[34448]=668,[34485]=680,[34487]=681,[34488]=679,[34527]=675,
	[34528]=674,[34541]=670,[34542]=684,[34543]=683,[34545]=682,[34546]=672,[34547]=673,[34549]=669,[34554]=678,
	[34555]=677,[34556]=676,[34557]=671,[34558]=668,[34559]=681,[34560]=679,[34561]=680,[34562]=675,[34563]=674,
	[34564]=670,[34565]=683,[34566]=684,[34567]=682,[34568]=673,[34569]=672,[34570]=669,[34571]=678,[34572]=677,
	[34573]=676,[34574]=671,[34575]=668,[34703]=737,[34990]=200586,[34991]=200586,[34992]=200586,[34993]=200586,[34994]=200586,
	[34998]=200584,[34999]=200584,[35000]=200584,[35001]=200584,[35002]=200584,[35003]=200568,[35004]=200568,[35005]=200568,[35006]=200568,
	[35007]=200568,[35009]=200615,[35010]=200615,[35011]=200615,[35012]=200615,[35013]=200615,[35022]=200685,[35023]=200685,[35024]=200685,
	[35025]=200685,[35026]=200685,[35027]=200582,[35028]=200582,[35029]=200582,[35030]=200582,[35031]=200582,[35032]=200577,[35033]=200577,
	[35034]=200577,[35035]=200577,[35036]=200577,[35042]=200578,[35043]=200578,[35044]=200578,[35045]=200578,[35046]=200578,[35048]=200580,
	[35049]=200580,[35050]=200580,[35051]=200580,[35052]=200580,[35053]=200687,[35054]=200687,[35055]=200687,[35056]=200687,[35057]=200687,
	[35059]=200690,[35060]=200690,[35061]=200690,[35062]=200690,[35063]=200690,[35066]=200567,[35067]=200567,[35068]=200567,[35069]=200567,
	[35070]=200567,[35077]=200686,[35078]=200686,[35079]=200686,[35080]=200686,[35081]=200686,[35083]=200581,[35084]=200581,[35085]=200581,
	[35086]=200581,[35087]=200581,[35088]=200583,[35089]=200583,[35090]=200583,[35091]=200583,[35092]=200583,[35096]=200579,[35097]=200579,
	[35098]=200579,[35099]=200579,[35100]=200579,[35111]=200585,[35112]=200585,[35113]=200585,[35114]=200585,[35115]=200585,[35328]=738,
	[35329]=738,[35330]=738,[35331]=738,[35332]=738,[35333]=739,[35334]=739,[35335]=739,[35336]=739,[35337]=739,
	[35338]=740,[35339]=740,[35340]=740,[35341]=740,[35342]=740,[35343]=741,[35344]=741,[35345]=741,[35346]=741,
	[35347]=741,[35356]=742,[35357]=742,[35358]=742,[35359]=742,[35360]=742,[35361]=744,[35362]=744,[35363]=744,
	[35364]=744,[35365]=744,[35366]=745,[35367]=745,[35368]=745,[35369]=745,[35370]=745,[35371]=743,[35372]=743,
	[35373]=743,[35374]=743,[35375]=743,[35376]=749,[35377]=749,[35378]=749,[35379]=749,[35380]=749,[35381]=748,
	[35382]=748,[35383]=748,[35384]=748,[35385]=748,[35386]=746,[35387]=746,[35388]=746,[35389]=746,[35390]=746,
	[35391]=747,[35392]=747,[35393]=747,[35394]=747,[35395]=747,[35402]=751,[35403]=751,[35404]=751,[35405]=751,
	[35406]=751,[35407]=750,[35408]=750,[35409]=750,[35410]=750,[35411]=750,[35412]=752,[35413]=752,[35414]=752,
	[35415]=752,[35416]=752,
--@end-version-bcc@
}

function ItemSet.GetSetName(setID, addQualityColor)
    if not ITEM_SET_DATA[setID] then return end
	local setName = ITEM_SET_DATA[setID][7] or GetItemSetInfo(setID)
    if addQualityColor then
        return format("%s%s|r", COLOR_STRINGS[ITEM_SET_DATA[setID][3]], setName or UNKNOWN)
    else
        return setName
    end
end

function ItemSet.GetSetIDforItemID(itemID)
	return ITEM_TO_SET[itemID]
end

function ItemSet.GetSetItems(setID)
    return ITEM_SET_DATA[setID] and ITEM_SET_DATA[setID][1] or nil
end

function ItemSet.GetSetIcon(setID, useClassIcon)
    if not ITEM_SET_DATA[setID] then return end
	if SPECIAL_ICONS[setID] then
		return SPECIAL_ICONS[setID]
    else
        if useClassIcon and ITEM_SET_DATA[setID][5] and CLASS_BIT_TO_CLASS[ITEM_SET_DATA[setID][5]] then
            return ICON_PATH_CLASS[CLASS_BIT_TO_CLASS[ITEM_SET_DATA[setID][5]]]
        else
            return GetItemIcon(ITEM_SET_DATA[setID][1][1]) or NO_ICON
        end
	end
end

function ItemSet.GetPhaseTextureForSetID(setID)
    if not ITEM_SET_DATA[setID] then return end
    if not ContentPhaseCache[setID] then
        local content = ITEM_SET_DATA[setID][1]
        local phase = 0
        for i = 1, #content do
            local c = ContentPhase:GetForItemID(content[i])
            phase = ( c and c > phase ) and c or phase
        end

        ContentPhaseCache[setID] = phase
    end
    return ContentPhaseCache[setID]
end

function ItemSet.GetSetDescriptionString(setID)
    if not ITEM_SET_DATA[setID] then return end
    local itemType
    if ITEM_SET_DATA[setID][5] and CLASS_BIT_TO_CLASS[ITEM_SET_DATA[setID][5]] then
        itemType = CLASS_NAMES_WITH_COLORS[CLASS_BIT_TO_CLASS[ITEM_SET_DATA[setID][5]]]
    else
        itemType = ITEM_SET_DATA[setID][2] > 0 and GetItemSubClassInfo(4, ITEM_SET_DATA[setID][2]) or ""
    end

    if itemType and itemType ~= "" then
        return format("%s%s | |cff00ccffiLvlAvg:|r %d", Requirements.BuildClassString(ITEM_SET_DATA[setID][5]), itemType, ITEM_SET_DATA[setID][4])
    elseif ITEM_SET_DATA[setID][5] > 0 then
        return format("%s |cff00ccffiLvlAvg:|r %d", Requirements.BuildClassString(ITEM_SET_DATA[setID][5]), ITEM_SET_DATA[setID][4])
    else
        return format("|cff00ccffiLvlAvg:|r %d", ITEM_SET_DATA[setID][4])
    end
end

function ItemSet.GetSetDataForExtraFrame(setID)
    if not ITEM_SET_DATA[setID] then return end
    local data = {"set"..setID, 0}
    for i = 1, #ITEM_SET_DATA[setID][1] do
        data[#data+1] = ITEM_SET_DATA[setID][1][i]
    end
    return data
end

local BONUS_FORMAT_STRING = AL["(%d) Set:"].." |cffffffff%s|r\n"
function ItemSet.GetSetBonusString(setID)
	if not ITEM_SET_DATA[setID] or not ITEM_SET_DATA[setID][6] then return end
	local ret = ""
	for i,spellEntry in ipairs(ITEM_SET_DATA[setID][6]) do
		local spellText = GetSpellDescription(spellEntry[2])
		if not spellText or spellText == "" then
			ret = false
		end
		if ret then
			ret = ret..format(BONUS_FORMAT_STRING, spellEntry[1], spellText)
		end
	end
	return ret
end